uniform vec4 normalizedBounds;  // start x, start y, end x, end y -- bounds of facet normalized to full surface coordinates
uniform vec4 padding;           // left, bottom, right, top
varying vec2 positionInFullSurface;
varying vec2 positionInInsetSurface;
varying vec2 positionInFacet;

float unmap_1d( float oldX, float oldStart, float oldEnd )
{
    return ( oldX - oldStart ) / ( oldEnd - oldStart );
}

vec2 unmap_2d( vec2 old, vec2 oldStart, vec2 oldEnd )
{
    return vec2( unmap_1d( old.x, oldStart.x, oldEnd.x ), unmap_1d( old.y, oldStart.y, oldEnd.y ) );
}

void main()
{
    gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
    gl_FrontColor = gl_Color;
    gl_TexCoord[0] = gl_TextureMatrix[0] * gl_MultiTexCoord0;
    positionInFullSurface = gl_TexCoord[0].xy;
    positionInInsetSurface = unmap_2d( positionInFullSurface, padding.xy, padding.zw );
    positionInFacet = unmap_2d( positionInFullSurface, normalizedBounds.xy, normalizedBounds.zw );
}